package book.beans;

import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

/**
 *
 * @author Leonard
 */
public class PlayerPhaseListenerA implements PhaseListener {
    
    private static final Logger logger = Logger.getLogger(PlayerPhaseListenerA.class.getName());

    @Override
    public void afterPhase(PhaseEvent event) {
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        processComponents(event.getFacesContext().getViewRoot());
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void processComponents(UIComponent root) {
        for (UIComponent child : root.getChildren()) {
            if (child.getId().equals("playerId")) {                
               logger.info("Obiekt nasłuchujący PlayerPhaseListenerA wywołano na rzecz komponentu o identyfikatorze playerId!");
            }
            processComponents(child);
        }
    }
}
